function initSpinner() {
  let target = document.getElementById("ev-sync-spinner");
  if (target) {
    startSpinner(target);
  }
}

function startSpinner(target) {
  //build your very own spinner at: https://spin.js.org/
  var opts = {
    lines: 16, // The number of lines to draw
    length: 80, // The length of each line
    width: 52, // The line thickness
    radius: 63, // The radius of the inner circle
    scale: 0.5, // Scales overall size of the spinner
    corners: 1, // Corner roundness (0..1)
    speed: 0.8, // Rounds per second
    rotate: 0, // The rotation offset
    animation: "spinner-line-shrink", // The CSS animation name for the lines
    direction: 1, // 1: clockwise, -1: counterclockwise
    color: "#0080ff", // CSS color or array of colors
    fadeColor: "transparent", // CSS color or array of colors
    top: "25%", // Top position relative to parent
    left: "25%", // Left position relative to parent
    shadow: "0 0 1px transparent", // Box-shadow for the lines
    zIndex: 2000000000, // The z-index (defaults to 2e9)
    className: "spinner", // The CSS class to assign to the spinner
    position: "absolute", // Element positioning
  };

  //sadly enough this does not work :// -> i cannot see the spinner - don't know why???
  var spinner = new Spin.Spinner(opts).spin();
  target.appendChild(spinner.el);

  console.log("spinner:" + JSON.stringify(spinner));
}

function loadQuote(figure, catChooser) {
  let selectedCategory = catChooser.val();

  jQuery.ajax({
    url: dxcp_admin_script_data.rest_api_quote_url + `?cat=${selectedCategory}`,
    type: "GET",
    data: {
      nonce: dxcp_admin_script_data.nonce,
    },
    success: function (quote) {
      figure.find("#qquote").text(quote.quote);
      figure.find("#qauthor").text(quote.author);
      figure.find("#qcategory").text(`(${quote.category})`);
    },
    error: function (xhr, status, error) {
      console.error(`XHR: ${xhr} | Status: ${status} | Error: ${error}`);
    },
  });
}
