<?php

/**
 * Contains all used table names of the plugin. The listed table-names are not prefixed.
 */
enum DXCctTableEnum: string
{
    case WpPosts = 'posts';

    case JetPostTypes = 'jet_post_types';
    case JetRelDefault = 'jet_rel_default';
    case JetRelDefaultMeta = 'jet_rel_default_meta';

    case CctKurs = 'jet_cct_kurs';
    case CctKursgruppe = 'jet_cct_kursgruppe';
    case CctKurstyp = 'jet_cct_kurstyp';
    case CctKursstufe = 'jet_cct_kursstufe';
    case CctKursleiter = 'jet_cct_kursleiter';
    case CctEvent = 'jet_cct_event';
    case CctMenu = 'jet_cct_menu';

    public static function wpdb_prefix(DXCctTableEnum $cctTable)
    {
        global $wpdb;
        $prefixedTable = $wpdb->prefix . $cctTable->value;

        return $prefixedTable;
    }

    public static function getCctTablesWithCctSinglePostIds(): array
    {
        $result = array();

        $result[] = DXCctTableEnum::CctKurs->wpdb_prefix(DXCctTableEnum::CctKurs);
        $result[] = DXCctTableEnum::CctKursgruppe->wpdb_prefix(DXCctTableEnum::CctKursgruppe);
        $result[] = DXCctTableEnum::CctKurstyp->wpdb_prefix(DXCctTableEnum::CctKurstyp);
        $result[] = DXCctTableEnum::CctKursstufe->wpdb_prefix(DXCctTableEnum::CctKursstufe);
        $result[] = DXCctTableEnum::CctKursleiter->wpdb_prefix(DXCctTableEnum::CctKursleiter);
        $result[] = DXCctTableEnum::CctEvent->wpdb_prefix(DXCctTableEnum::CctEvent);

        return $result;
    }
}

enum DXTypeEnum: string
{
    case Kurs = 'Kurs';
    case Kursleiter = 'Kursleiter';
    case Kursstufe = 'Kursstufe';
    case Kurstyp = 'Kurstyp';
    case Kursgruppe = 'Kursgruppe';
    case Event = 'Event';
    case Menu = 'Menu';
}

enum DXMsgTypeEnum: string
{
    case Error = 'error';
    case Warning = 'warning';
    case Success = 'success';
    case Info = 'info';
}

class DXRestOptions
{
    public string $endpoint;
    public string $apiKey;
}

class DXType
{
    public DXTypeEnum $typeEnum;
    public string $cptName;
    public DXCctTableEnum $tableEnum;

    public function __construct(DXTypeEnum $typeEnum, DXCctTableEnum $tableEnum)
    {
        $cpt_praefix = "CPT";

        $this->typeEnum = $typeEnum;
        $this->cptName = "{$cpt_praefix}_{$typeEnum->value}";
        $this->tableEnum = $tableEnum;
    }

    public static function GetAllTypes(): array
    {
        $types = array();

        $types[] = new DXType(DXTypeEnum::Kurs, DXCctTableEnum::CctKurs);
        $types[] = new DXType(DXTypeEnum::Kursleiter, DXCctTableEnum::CctKursleiter);
        $types[] = new DXType(DXTypeEnum::Kursstufe, DXCctTableEnum::CctKursstufe);
        $types[] = new DXType(DXTypeEnum::Kurstyp, DXCctTableEnum::CctKurstyp);
        $types[] = new DXType(DXTypeEnum::Kursgruppe, DXCctTableEnum::CctKursgruppe);
        $types[] = new DXType(DXTypeEnum::Event, DXCctTableEnum::CctEvent);
        $types[] = new DXType(DXTypeEnum::Menu, DXCctTableEnum::CctMenu);

        return $types;
    }

    public static function GetType(DXTypeEnum $typeEnum): DXType
    {
        $types = DXType::GetAllTypes();

        $arr = array_filter($types, function ($item) use ($typeEnum) {
            if ($item->typeEnum->value == $typeEnum->value) {
                return true;
            }
        });

        if (count($arr) == 1)
            //array_filter keeps the IDs of the array *facePalm*
            return reset($arr);

        return null;
    }
}
