
# this PS automatically creates a zipped plugin package outside of the current plugin structure (which is the plugins folder of WP) with the .git folder deleted


# we use 7-Zip because somehow the default Compress-Archive-command of PS creates invalid packages - i did not find out why exactly - i used up hours but i dont know
$7zPath = "C:\Program Files\7-Zip\7z.exe"

# main file of the dance-x-plugin
$pluginMainFile = "$PSScriptRoot\dance-x-connector.php";

# we extract the version of the main file
$versionLine = Get-Content $pluginMainFile -TotalCount 20 | Select-String "Version:"
$splittedVersionLine = $versionLine -split " "
$version = $splittedVersionLine[1]

# folder of dance-x-plugin
$folderToZip = [System.IO.Path]::GetFullPath("$PSScriptRoot\..\dance-x-connector")

# TMP folder to do some cleaning work
$folderToZipCopy = [System.IO.Path]::GetFullPath("$PSScriptRoot\..\TMP\dance-x-connector")

# final zip file
$targetZipFile = [System.IO.Path]::GetFullPath("$PSScriptRoot\..\dance-x-connector_$version.zip")


#--- Processing ---#


# delete the target folder if it is there
if(Test-Path -Path $folderToZipCopy -PathType Any)
{
    Remove-Item -Path $folderToZipCopy -Force -Recurse
}

# delete the target zip if it is there
if(Test-Path -Path $targetZipFile -PathType Any)
{
    Remove-Item -Path $targetZipFile -Force -Recurse
}


# were copying the orginal folder to a new folder
Copy-Item -Path $folderToZip -Destination $folderToZipCopy -Force -Recurse

# remove the git-folder (because we don't need that inside the plugin)
Remove-Item -Path "$folderToZipCopy\.git" -Force -Recurse 

# ZIP the copied and cleaned folder
&$7zPath a -tzip -mx9 $targetZipFile $folderToZipCopy


pause